#include <iostream>
#include <string>
#include <cstdlib>
#include <cstdio>
#include <algorithm>
#include <map>
#include <set>
#include <vector>
#include <cmath>
#include <cstring>
#include <queue>
#include <deque>
#include <functional>
#include <climits>

#define mp make_pair
#define mt(a, b, c) mp(a, mp(b, c))
#define ABS(a) (((a) > 0) ? (a) : (-(a)))
#define ZERO(x) memset((x), 0, sizeof(x))
#define X first
#define Y second

using namespace std;
typedef long long ll;
typedef unsigned long long ull;
typedef pair<int, int> ii;
typedef pair<int, ii> iii;

const int MAX_N = 20050;

int n, m;
vector<iii> g[MAX_N];

int dst[MAX_N];
int rel[MAX_N];
vector<iii> par[MAX_N];

void dijkstra()
{
	set<ii> ds;
	for (int i = 0; i < n; ++i)
	{
		dst[i] = INT_MAX;
	}
	dst[0] = 0;
	ds.insert(mp(0, 0));

	while (!ds.empty())
	{
		set<ii>::iterator it = ds.begin();
		int len = it->X;
		int v = it->Y;
		ds.erase(it);

		for (int i = 0; i < g[v].size(); ++i)
		{
			int to_v = g[v][i].X;
			int to_l = g[v][i].Y.X;
			if (dst[v] + to_l <= dst[to_v])
			{
				if (dst[v] + to_l == dst[to_v])
				{
					++rel[to_v];
				}
				else
				{
					rel[to_v] = 1;
					ds.erase(mp(dst[to_v], to_v));
					dst[to_v] = dst[v] + to_l;
					ds.insert(mp(dst[to_v], to_v));
					par[to_v].clear();
				}
				par[to_v].push_back(mt(v, to_l, g[v][i].Y.Y));
			}
		}
	}
}

set<ii> alt_path;

int main()
{
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
	
	cin >> n >> m;
	for (int i = 0; i < m; ++i)
	{
		int a, b, l;
		cin >> a >> b >> l;
		--a; --b;
		g[a].push_back(mt(b, l, i+1));
		g[b].push_back(mt(a, l, i+1));
	}

	dijkstra();

	int cur = n-1;
	vector<int> ans;
	while (cur != 0)
	{
		if (alt_path.empty())
		{
			if (par[cur].size() == 1)
			{
				ans.push_back(par[cur][0].Y.Y);
				cur = par[cur][0].X;
			}
			else
			{
				for (int i = 0; i < par[cur].size(); ++i)
				{
					alt_path.insert(mp(par[cur][i].Y.X, par[cur][i].X));
				}
			}
		}
		else
		{
			set<ii>::iterator it = alt_path.begin();
			int min_l = it->first;
			int min_v = it->second;

			alt_path.erase(it);
			if (alt_path.empty())
			{
				cur = min_v;
				continue;
			}

			for (int i = 0; i < par[min_v].size(); ++i)
			{
				alt_path.insert(mp(par[min_v][i].Y.X + min_l, par[min_v][i].X));
			}
		}
	}

	cout << ans.size() << endl;
	for (int i = 0; i < ans.size(); ++i)
	{
		cout << ans[i] << " ";
	}


	return 0;
}